/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.lux;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.PlayerCreatureEntity;
import entities.creatures.enemies.LuxEntity;
import entities.missiles.MissileEntity;
import java.util.Random;
import util.Config;
import util.ResourceManager;

public final class LuxShotEntity
extends MissileEntity {
    private long lastFrameChange;
    private Random random = new Random();
    private boolean used = false;

    public LuxShotEntity(LuxEntity parent, GameState game, int x, int y) {
        super(parent, game, "missiles/lux/shot", x, y);
        this.moveSpeed = Config.get(Config.luxShotProjectileSpeed);
        switch (game.getDifficulty()) {
            case HARD: 
            case LEGENDARY: {
                this.dy = Math.max(this.random.nextDouble() * this.moveSpeed, this.moveSpeed);
                this.dx = this.random.nextDouble() * this.dy;
                if (this.random.nextBoolean()) {
                    this.dx = -this.dx;
                }
                if (!this.random.nextBoolean()) break;
                this.dy = -this.dy;
                break;
            }
            default: {
                this.dy = Math.max(this.random.nextDouble() * this.moveSpeed, this.moveSpeed);
                this.dx = this.random.nextDouble() * (this.dy / 2.0);
            }
        }
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        this.lastFrameChange += delta;
        if (this.lastFrameChange > 10L) {
            this.lastFrameChange = 0L;
            this.sprite.rotate(45.0f);
        }
    }

    @Override
    public void collidedWith(Entity other) {
        if (this.used) {
            return;
        }
        if (other instanceof PlayerCreatureEntity) {
            this.game.removeEntity(this);
            int damage = Config.get(Config.luxShotDamage);
            if (((CreatureEntity)other).hasEffect("passiveLux")) {
                damage = (int)((double)damage * Config.get(Config.luxPassiveMultiplier));
                ((CreatureEntity)other).removeEffect("passiveLux");
                ResourceManager.get().playSound("lux_passive_hit");
            } else {
                ResourceManager.get().playSound("lux_shot_hit");
            }
            ((CreatureEntity)other).damage(this, damage);
            this.used = true;
        }
    }
}

